import tkinter as tk
import re

window = tk.Tk()
window.grid_columnconfigure(0, weight=1)
window.title("Calculator")
window.geometry("400x600")

window.grid_rowconfigure(0, weight=1)
window.grid_columnconfigure(0, weight=1)
buttons = [
    ("C", 2, 0),              ("^", 2, 2), ("Del", 2, 3),
    ("7", 3, 0), ("8", 3, 1), ("9", 3, 2), ("/", 3, 3),
    ("4", 4, 0), ("5", 4, 1), ("6", 4, 2), ("*", 4, 3),
    ("1", 5, 0), ("2", 5, 1), ("3", 5, 2), ("-", 5, 3),
    ("0", 6, 0), (".", 6, 1), ("=", 6, 2), ("+", 6, 3),
]

temp_inp = []
last_result = None

label = tk.Label(window, text = '',font=("Arial", 20),anchor="e",bg="white")
label.grid(column=0, row=0, columnspan=4,sticky="nsew",padx=5, pady=5)

label2 = tk.Label(window, text='', font=("Arial", 15), bg="white")
label2.grid(row=1, column=0, columnspan=4, sticky="nsew", padx=5, pady=5)

def handle_expression(expr: str) -> str:
    """Remove leading zeros from integers like 06 → 6."""
    expr = expr.replace("^", "**")
    return re.sub(r"\b0+(\d+)(?!\.)", r"\1", expr)

def store_inp(num):
    global last_result 

    if num == "Del":
        if temp_inp:
            temp_inp[-1] = temp_inp[-1][:-1]  # remove last char
            if temp_inp[-1] == "":            # if empty, remove it
                temp_inp.pop()

    elif num == "C":
        temp_inp.clear()
        last_result = None

    elif num.isdigit() or num == ".":  # number or decimal
        if temp_inp and temp_inp[-1].replace('.', '').isdigit():
            # If user tries to add another ".", block it
            if num == "." and "." in temp_inp[-1]:
                pass  # ignore extra decimal
            else:
                temp_inp[-1] += num
        else:
            if num == ".":
                temp_inp.append("0.")  
            else:
                temp_inp.append(num)

    elif num in ["+", "-", "*", "/","^"]:
        if temp_inp:
            if temp_inp[-1] in ["+", "-", "*", "/", "^"]:
                temp_inp[-1] = num   # replace operator
            else:
                temp_inp.append(num) # add operator

    elif num == "=":
        expr = "".join(temp_inp)
        expr = handle_expression(expr)

        try:
            last_result = eval(expr)
            print(last_result)
            temp_inp.clear()
            temp_inp.append(str(last_result))   # reuse same list
        except ZeroDivisionError:
            label.config(text="Divide by 0 Error")
            # label2.config(text="Divide by 0 Error")
            temp_inp.clear()
            return

        except Exception as e:
            print("Error")
            print(e)
            temp_inp.clear()
            return
    else:
        temp_inp.append(num)
        print("else called ")

    label.config(text="".join(temp_inp))
    expr = "".join(temp_inp)
    expr = handle_expression(expr)

    try:
        last_result = eval(expr)
        label2.config(text=str(last_result))
    except ZeroDivisionError:
        label2.config(text="Divide by 0 Error")
    except Exception:
        # if the expression is incomplete (like "9+"), just clear label2
        label2.config(text=str(last_result))

for (num,row,col) in buttons:
    btn = tk.Button(window,command=lambda num=num: store_inp(num), text=num, width=5)
    btn.grid(column=col, row=row, padx=3, pady=3, ipadx=5, ipady=5, sticky="nsew")

# Make all columns expand equally
for i in range(4):
    window.grid_columnconfigure(i, weight=1)

window.mainloop() 